<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Verified;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use App\Models\User;
use Auth;
use Validator;
use Illuminate\Support\Facades\DB;
use Storage;


class VerifyEmailController extends Controller
{
    /**
     * Mark the authenticated user's email address as verified.
     *
     * @param  \Illuminate\Foundation\Auth\EmailVerificationRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function __invoke(EmailVerificationRequest $request)
    {
        if ($request->user()->hasVerifiedEmail()) {
            return redirect()->intended(RouteServiceProvider::HOME.'?verified=1');
        }

        if ($request->user()->markEmailAsVerified()) {
            event(new Verified($request->user()));
            $id = auth()->user()->id;
            $veri = DB::table('users')
              ->where('id', $id)
              ->update(['verified' => 1]);
            $email = auth()->user()->email;
            $firstname = auth()->user()->firstname;
            $to = "$email";
            $subject = "Welcome To Goldspot Family";

            $message = view('welcome_email', [ 'firstname' => $firstname ]);

            // Always set content-type when sending HTML email
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

            // More headers
            $headers .= 'From:Goldspot <info@netwise.site>' . "\r\n";

            mail($to,$subject,$message,$headers);

        return redirect()->intended(RouteServiceProvider::HOME.'?verified=1');
        }
    }
}
