<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use App\Models\User;
use App\Models\UserOtp;
use App\Models\notification;
use App\Models\bankaccount;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;
use App\Models\btctransaction;
use Illuminate\Support\Facades\Mail;

class AuthController extends Controller
{

    public function resendOtp(Request $request)
{
    $request->validate([
        'email' => 'required|email|exists:users,email', // Validate that the email exists in the database
    ]);

    // Get the user based on the email
    $user = User::where('email', $request->email)->first();

    // Check if the user has already verified their email
    if ($user->verified) {
        return response()->json(['message' => 'Your email has already been verified.'], 400);
    }

    // Generate a new OTP
    $otp = rand(100000, 999999); // Generate a random 6-digit OTP

    // Save the OTP in the 'user_otps' table
    UserOtp::updateOrCreate(
        ['user_id' => $user->id],
        ['otp' => $otp, 'created_at' => now()]
    );

    // Send the OTP to the user's email
    Mail::raw("Your OTP is: $otp", function ($message) use ($user) {
        $message->to($user->email)
                ->subject('OTP for Verification');
    });

    return response()->json(['message' => 'OTP has been sent to your email.'], 200);
}

    public function _construct(){
        $this->muddleware('auth:api',['except'=>['login','register']]);
    }

    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'firstname' => 'required|string|max:15|regex:/^[a-zA-ZÑñ\s]+$/',
            'lastname' => 'required|string|max:15|regex:/^[a-zA-ZÑñ\s]+$/',
            'email' => 'required|string|email|unique:users',
            'phoneno' => 'required|numeric|min:9|regex:/^[-0-9\+]+$/',
            'password' => 'required|string|confirmed|min:6|regex:/^[a-zA-ZÑñ0-9\s]+$/',
            'reference' => ''
        ], [
            'password.regex' => 'Only alphanumeric characters allowed for password',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors()->toJson(), 400);
        }

        // Create the user
        $user = User::create(array_merge(
            $validator->validated(),
            ['password' => bcrypt($request->password)],
            ['verified' => 0, 'email_verified_at' => null] // Ensure email verification is pending
        ));

        // Generate OTP
        $otp = random_int(100000, 999999);

        // Store OTP in the database
        DB::table('user_otps')->insert([
            'email' => $user->email,
            'otp' => $otp,
            'created_at' => Carbon::now(),
            'expires_at' => Carbon::now()->addMinutes(10) // OTP expires in 10 minutes
        ]);

        // Send OTP via email
        Mail::raw("Your verification code is: {$otp}", function ($message) use ($user) {
            $message->to($user->email)
                    ->subject('Email Verification Code');
        });

        return response()->json([
            'status' => '201',
            'message' => 'User successfully registered. Please check your email for the OTP.',
            'user' => $user
        ]);
    }

    public function verifyOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|exists:users,email',
            'otp' => 'required|numeric|digits:6'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }

        $otpRecord = DB::table('user_otps')
            ->where('email', $request->email)
            ->where('otp', $request->otp)
            ->where('expires_at', '>', Carbon::now())
            ->first();

        if (!$otpRecord) {
            return response()->json([
                'message' => 'Invalid or expired OTP'
            ], 400);
        }

        // Update user verification status
        User::where('email', $request->email)->update([
            'verified' => 1,
            'email_verified_at' => Carbon::now()
        ]);

        // Delete the OTP record after successful verification
        DB::table('user_otps')->where('email', $request->email)->delete();

        return response()->json([
            'message' => 'Email successfully verified'
        ], 200);
    }


    public function login(Request $request){
        $validator =Validator::make($request->all(),[
            'email'=>'required|email',
            'password'=>'required|string|min:6'
        ],
        [
                'password.min' => 'Only alphanumeric characters allowed for password',
            ]);
        if($validator->fails()){
            return response()->json(['error'=>'Password must be a minimum of 6 characters', 'status' => '401']);
        }
        if(!$token=auth()->guard('api')->attempt($validator->validated())){
            return response()->json(['error'=>'Invalid credentials', 'status' => '401']);
        }
        if(auth()->guard('api')->user()->verified == 0){
            return response()->json(['error'=>'please check your email for link to verify your email', 'status' => '401']);
        }
        $user = User::find(Auth::guard('api')->user()->id);
        $userr = DB::table('users')->where('referralcode', $user->reference)->first();
        if (empty($user->referralcode)){
            $user->update([
            'referralcode' => Str::random(5),
            'last_login_at' => Carbon::now()->toDateTimeString(),
            'last_login_ip' => $request->getClientIp() ]);
        if ($userr->referralcode != null){
            $user->update([
            'referenceid' => $userr->email]);
        }
        else{
            $user->update([
            'referenceid' => null]);
        }
        }
        else{
        $user->update([
            'last_login_at' => Carbon::now()->toDateTimeString(),
            'last_login_ip' => $request->getClientIp() ]);
        }
        return $this->createNewToken($token);
    }
    public function createNewToken($token){
        return response()->json([
            'access_token'=>$token,
            'token_type'=>'bearer',
            'expires_in'=>auth()->guard('api')->factory()->getTTL()*60,
            'user'=>auth()->guard('api')->user(),
            'status'=>'200'
        ]);
    }
    public function refresh() {
        return $this->createNewToken(Auth::guard('api')->refresh());
    }
    public function profile(){
        return response()->json(auth()->guard('api')->user(), 200);
    }
    public function logout(){
        auth()->guard('api')->logout();
        return response()->json([
            'message'=>'User logged out',
            'status'=>'200'
        ]);
    }
    public function updateprofile(Request $request){
        $validator =Validator::make($request->all(),[
            'firstname'=>'required|min:2|max:25',
            'lastname'=>'required|min:2|max:25',
            'phoneno'=>'required|numeric',
            'username'=>'string'
        ]);

        if($validator->fails()){
            return response()->json($validator->errors()->toJson(),400);
        }
        else{
        $user = User::find(Auth::guard('api')->user()->id);
        $user->firstname = $request->firstname;
        $user->lastname = $request->lastname;
        $user->phoneno = $request->phoneno;
        $user->username = $request->username;
        }
        $user->update();
        return response()->json([
            'message'=>'Profile updated',
            'user'=>$user,
            'status'=>'201'
        ]);
    }
    public function updatepin(Request $request){
        $validator =Validator::make($request->all(),[
            'pin'=>'required|numeric|min:4',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors()->toJson(),400);
        }
        else{
        $user = User::find(Auth::guard('api')->user()->id);
        $user->pin = Crypt::encryptString($request->pin);
        }
        $user->update();
        return response()->json([
            'message'=>'Pin updated',
            'user'=>$user,
            'status'=>'201'
        ]);
    }
    public function validatepin(Request $request){
        $pin = $request->pin;
        $user = User::find(User::find(Auth::guard('api')->user()->id));
        if ($pin == Crypt::decryptString(auth()->guard('api')->user()->pin)){
        return response()->json([
            'message'=>'Pin correct',
            'status'=>'200'
        ]);}
        else {
            return response()->json([
                'message'=>'Pin incorrect',
                'status'=>'400'
            ]);
        }
    }
    public function resetpin(Request $request) {
        $validator =Validator::make($request->all(),[
            'oldpin'=>'required|numeric|min:4',
            'pin'=>'required|numeric|min:4',
        ]);
        $oldpin = Crypt::decryptString(auth()->guard('api')->user()->pin);
        $user = User::find(Auth::guard('api')->user()->id);

        if ($oldpin != $request->oldpin) {
            return response()->json(["msg" => "Invalid pin provided", 'status' => '400']);
        }
        if ($oldpin == $request->pin) {
            return response()->json(["msg" => "You can not use old pin", 'status' => '400']);
        }
        else{
            $user = User::find(Auth::guard('api')->user()->id);
            $user->pin = Crypt::encryptString($request->pin);
            }
            $user->update();
            return response()->json([
                'message'=>'Pin has been successfully changed', 'status' => '201'
            ]);
    }
    public function updateaccount(Request $request){
        $validator =Validator::make($request->all(),[
            'bankcode'=>'required|min:2|max:25',
            'accountno'=>'required|numeric|min:10',
            'bank'=>'string',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors()->toJson(),400);
        }
        else{
                $response = Http::withHeaders([
            'Authorization' => 'Bearer FLWSECK-cc643e8c3aaba7f4e048afa49493fccd-X'
        ])->post('https://api.flutterwave.com/v3/accounts/resolve', [
            'account_number' => $request->accountno,
            'account_bank' => $request->bankcode,
        ]);
        $namee = $response->object()->data->account_name;
        if ($response->status() == 200){
        $bankaccount = new bankaccount;
        $bankaccount->accountname = $namee;
        $bankaccount->email = Auth::guard('api')->user()->email;
        $bankaccount->accountno = $request->accountno;
        $bankaccount->bank = $request->bank;
        $bankaccount->bankcode = $request->bankcode;
        $bankaccount->image = $request->image;
        $bankaccount->save();
        return response()->json([
            'message'=>'Account Details Updated',
            'accountname'=>$namee,
            'status'=>201
        ]);
        }
        else {
            return response()->json([
            'message'=>'Wrong Account Number/Bank',
            'user'=>400
        ]);
        }
        }

    }
    public function updateProfilePic(Request $request){
        $validator =Validator::make($request->all(),[
            'profile_pic'=>'required',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors()->toJson(),400);
        }
        else{
        $user = User::find(Auth::guard('api')->user()->id);
        $user->profile_pic = $request->profile_pic;
        }
        $user->update();
        return response()->json([
            'message'=>'Profile Picture updated',
            'user'=>$user->profile_pic,
            'status'=>201
        ]);
    }
    public function viewaccount(){
        $email = Auth::guard('api')->user()->email;
        $bankaccount = DB::table('bankaccounts')
            ->select('id', 'email', 'accountno', 'accountname', 'bank', 'bankcode', 'image')
            ->get()->where('email', $email);
            return (['bankacounts' => $bankaccount->values()]);
        }
    public function deleteAccount(Request $request){
        $account = $request->accountno;
        DB::table('bankaccounts')->where('accountno', $account)->delete();
            return (["result" => "Account Deleted"]);
        }
    public function newNotification(Request $request){
        $notification = new notification;
        $notification->title = $request->title;
        $notification->message = $request->message;
        $notification->seen = 1;
        $result = $notification->save();
        if ($result){
            return ["result"=>"Notification Sent"];
        }
        else {
            return ["result"=>"Notification failed to send"];
        }
    }
    public function getNotification(){
        $regdate = auth()->user()->created_at;
        $notification = DB::table('notifications')
            ->select('id', 'created_at', 'title', 'message', 'seen', 'updated_at')
            ->get()->where('created_at', '>=', $regdate)->sortByDesc('id');
            return (['notifications' => $notification->values()]);
    }
    public function contact(Request $request){
        $useremail = auth()->user()->email;
        $userfirstname = auth()->user()->firstname;
        $usermessage = $request->message;
        $to = "help@netwise.site";
            $subject = "New Contact Message";

            $message = "Hello Admin, $userfirstname with the email address $useremail just sent a new message. Message: $usermessage
            ";

            // Always set content-type when sending HTML email
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

            // More headers
            $headers = 'From: info@help@netwise.site' . "\r\n" .
                        'Reply-To: '.$useremail."\r\n" .
                        'X-Mailer: PHP/' . phpversion();

            mail($to,$subject,$message,$headers);
            return (['status' => '200',
                    'message' => 'message sent']);
    }
    public function sendmail(Request $request){
        $users = User::where('username','=', 'hi')->pluck('email');
        foreach($users as $users){
        $to = "$users";
            $subject = "Friday";

            $message = view('friday');

            // Always set content-type when sending HTML email
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

            // More headers
            $headers .= 'From: Goldspot <info@netwise.site>' . "\r\n";
            $headers .= 'bcc: info@netwise.site' . "\r\n";

            mail($to,$subject,$message,$headers);
        }
        return "Message Sent $users";
    }
    public function pushToken(Request $request){
        $useremail = Auth::guard('api')->user()->email;
        $token = $request->token;
        $user = User::find(Auth::guard('api')->user()->id);
        $user->push_token = $request->token;
        $user->update();
            return (['status' => '200',
                    'message' => 'token updated']);
    }
    public function userDelete(){
        $email = Auth::guard('api')->user()->email;
        DB::table('btctransactions')->where('email', $email)->delete();
        DB::table('usdttransactions')->where('email', $email)->delete();
        DB::table('cardtransactions')->where('email', $email)->delete();
        DB::table('withdrawals')->where('email', $email)->delete();
        DB::table('users')->where('email', $email)->delete();
            return (["result" => "User Account Deleted"]);
        }


}
