<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use App\Models\btctransaction;
use App\Models\usdttransaction;
use App\Models\cryptorate;
use Illuminate\Http\Request;

class CryptoTransactionController extends Controller
{
    public function sell(Request $request)
    {
        $request->validate([
            'coin' => 'required|in:BTC,USDT',
            'amount' => 'required|numeric|min:0.0001',
        ]);

        $user = Auth::user();
        $coin = strtoupper($request->coin);
        $amount = $request->amount;

        // Get the latest crypto rate
        $rate = cryptorate::latest()->first();

        if (!$rate) {
            return response()->json(['message' => 'Crypto rate not found'], 404);
        }

        $rateToUse = $coin === 'BTC' ? $rate->btcrate : $rate->usdtrate;
        $totalAmountInNaira = $amount * $rateToUse;

        // Save the transaction
        if ($coin === 'BTC') {
            btctransaction::create([
                'user_id' => $user->id,
                'email' => $user->email,
                'amount' => $amount,
                'total_amount' => $totalAmountInNaira,
                'type' => 'sell',
                'approved' => false,
                'failure' => false,
                'staff' => null,
                'accept' => false,
                'acceptedby' => null,
                'proof' => null,
            ]);
        } else {
            usdttransaction::create([
                'user_id' => $user->id,
                'email' => $user->email,
                'amount' => $amount,
                'total_amount' => $totalAmountInNaira,
                'type' => 'sell',
                'approved' => false,
                'failure' => false,
                'staff' => null,
                'accept' => false,
                'acceptedby' => null,
                'proof' => null,
            ]);
        }

        return response()->json([
            'message' => "$coin sale request submitted successfully.",
            'amount' => $amount,
            'naira_value' => $totalAmountInNaira
        ], 201);
    }
}
