<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\withdrawal;
use Auth;
use Validator;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class WithdrawalController extends Controller
{
    public function requestWithdrawal(Request $request){
        $withdrawal = new Withdrawal;

        //kill switch
        $status = DB::table('switch')->where('name', 'withdraw')->first();
        if ($status->status == 1){
        //validate
        $validator = Validator::make($request->all(), [
            'reference'    => 'nullable|string', //
            'amount'       => 'required|numeric|min:1',
            'email'        => 'required|email',
            'accountno'    => 'required|digits_between:10,20',
            'accountname'  => 'required|string|max:255',
            'bank'         => 'required|string|max:100',
            'bankcode'     => 'required|string|max:10', 
            'note'         => 'nullable|string|max:500',
            'bank_image'   => 'nullable|string|url',
        ]);
        if($validator->fails()){
            return response()->json($validator->errors()->toJson(),400);
        }
        else{
        $balancecharge = auth()->user()->balance;
        //confirm if withdrawal amount is 2,000 or more
        if ($request->amount >= 2000 && $balancecharge >= $request->amount){
        //confirm user has funds
        $withdrawal->amount = $request->amount;
        $withdrawal->accountname = $request->accountname;
        $withdrawal->accountno = $request->accountno;
        $withdrawal->bankcode = $request->bankcode;
        $withdrawal->bank = $request->bank;
        $withdrawal->note = $request->note;
        $withdrawal->bank_image = $request->bank_image;
        $withdrawal->email = auth()->user()->email;
        $phone = auth()->user()->phoneno;

        //deduct fund from user balance
        $balance = auth()->user()->balance;
            $user = User::find($request->user()->id);
            $user->balance = $balance - $withdrawal->amount;
            $email = auth()->user()->email;
            $firstname = auth()->user()->firstname;
            $result = $user->update();

            $withdrawal->save();
        if ($result){
                    //send fund to user account
        $response = Http::withHeaders([
            'api-key' => ''
        ])->post('https://api.fincra.com/disbursements/payouts/', [

                'business' => '62273817818de7416484a959',
                'sourceCurrency' => 'NGN',
                'destinationCurrency' => 'NGN',
                'amount' => $withdrawal->amount,
                'description' => 'goldspot',
                'paymentDestination' => 'bank_account',
                'beneficiary' => [
                    "firstName" => $withdrawal->accountname,
                    "lastName" => $withdrawal->accountname,
                    "accountHolderName" => $withdrawal->accountname,
                    "country" => "NG",
                    "phone" => "090",
                    "accountNumber" => $withdrawal->accountno,
                    "type" => "individual",
                    "email" => $withdrawal->email,
                    "bankCode" => $withdrawal->bankcode
                ]
            ]);

            //send email notification to user
            $to = "$withdrawal->email";
            $subject = "Withdrawal Processed";
            $theamount = $withdrawal->amount;
            $thebank = $withdrawal->bank;
            $firstname = $user->firstname;
            $newbal = $user->balance;
            $accountno = "$withdrawal->accountno";
            $accountno_hide = substr($accountno, 0, 4);
            $accountno_hide .= "****";
            $accountno_hide .= substr($accountno, 8, 4);
            $accountname = $withdrawal->accountname;

            $message = view('withdraw', [ 'firstname' => $firstname, 'theamount' => $theamount, 'newbal' => $newbal, 'thebank' => $thebank, 'accountno_hide' => $accountno_hide, 'accountname' => $accountname]);

            // Always set content-type when sending HTML email
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

            // More header
            $headers .= 'From: Goldspot <info@netwise.site>' . "\r\n";
            $headers .= 'bcc: info@netwise.site' . "\r\n";

            mail($to,$subject,$message,$headers);

            $withdrawal->id = $response->object()->data->id;
            $withdrawal->reference = $response->object()->data->reference;
            $withdrawal->update();

            return response()->json([
                'status'=> 200,
                'message'=> 'Withdrawal processed',
                'date'=> $withdrawal->created_at,
                'amount'=> $withdrawal->amount,
                'name'=> $withdrawal->accountname,
                'amount'=> $withdrawal->amount,
                'bank'=> $withdrawal->bank,
                'note'=> $withdrawal->note,
                'id'=>$response->object()->data->id,
                'reference'=>$response->object()->data->reference
            ],200);
        }
        else {
            return ["result"=>"Transaction failed to send"];
        }
        }
        else{
            return ["result"=>"Insufficient Funds"];
        }
        }
        }
        else {
            return ["result"=>"Currently unavailable"];
        }
    }
    public function selectWithdrawal(){
        $email = auth()->user()->email;
        $withdrawal = DB::table('withdrawals')
            ->select('id', 'accountno', 'accountname', 'bank', 'amount', 'email', 'created_at', 'bank_image')
            ->orderBy('id', 'DESC')->get()->where('email', $email);
            return (['withdrawals' => $withdrawal->values()]);
    }
        public function getBankList()
    {
        // Send request to the bank list endpoint
        $response = Http::withHeaders([
            'Bearer' => 'sk_live_bda5592c24abe6cb8047408066f9498bb625737b'
        ])->get('https://api.paystack.co/bank');

        // Check if the request was successful
        if ($response->successful()) {
            // Return the response directly
            return $response->json();
        } else {
            // Handle the case when the request fails
            return response()->json(['error' => 'Failed to retrieve bank list'], $response->status());
        }
    }

}
