<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Withdrawal extends Model
{
    use HasFactory;
    protected $fillable = [
        'amount'=>'required|numeric|regex:/^[-0-9\+]+$/',
        'accountno'=>'required|numeric|min:10|max:10',
        'accountname'=>'required|string',
        'bank'=>'required|string',
        'email'
    ];
}
