<?php

use App\Http\Controllers\Auth\VerificationController;
use App\Http\Controllers\Auth\VerifyEmailController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BtctransactionController;
use App\Http\Controllers\CardRatesController;
use App\Http\Controllers\CardtransactionController;
use App\Http\Controllers\CryptoratesController;
use App\Http\Controllers\CryptoTransactionController;
use App\Http\Controllers\CryptoWalletController;
use App\Http\Controllers\ForgotPasswordController;
use App\Http\Controllers\UsdttransactionController;
use App\Http\Controllers\WithdrawalController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('jwt.auth')->get('/user', function (Request $request) {
    return $request->user();
});
Route::group(['middleware'=>'api','prefix'=>'auth'],function($router){
    Route::post('/register',[AuthController::class,'register']);
    Route::post('/login',[AuthController::class,'login']);
    Route::post('/verify-otp', [AuthController::class, 'verifyOtp']);
    Route::get('/profile',[AuthController::class,'profile']);
    Route::get('/viewaccount',[AuthController::class,'viewaccount']);
    Route::post('/deleteaccount',[AuthController::class,'deleteaccount']);
    Route::post('/updateprofile',[AuthController::class,'updateprofile']);
    Route::post('/updatepin',[AuthController::class,'updatepin']);
    Route::post('/validatepin',[AuthController::class,'validatepin']);
    Route::post('/resetpin',[AuthController::class,'resetpin']);
    Route::post('/updateaccount',[AuthController::class,'updateaccount']);
    Route::post('/updatepic',[AuthController::class,'updateProfilePic']);
    Route::post('/logout',[AuthController::class,'logout']);
    });
Route::group(['middleware' => 'api'], function(){
    Route::get('/refresh',[AuthController::class,'refresh']);
});
Route::get('banks', [WithdrawalController::class, 'getBankList']);
Route::group(['middleware'=>'jwt.auth'],function($router){
    Route::get('/email/verify/{id}/{hash}', [VerifyEmailController::class, '__invoke'])
    ->middleware(['signed', 'throttle:6,1'])
    ->name('verification.verify');
    Route::post('/email/verify/resend', function (Request $request) {
    $request->user()->sendEmailVerificationNotification();
    return back()->with('message', 'Verification link sent!');
    })->middleware(['auth:api', 'throttle:6,1'])->name('verification.send');
    });

    Route::group(['middleware'=>'jwt.auth'],function($router){
        Route::post('/btctransaction',[BtctransactionController::class,'addBtctransaction']);
        Route::get('/selectbtctransaction',[BtctransactionController::class,'selectBtctransaction']);
        });
    Route::group(['middleware'=>'jwt.auth'],function($router){
        Route::post('/cardtransaction',[CardtransactionController::class,'addCardtransaction']);
        Route::get('/selectcardtransaction',[CardtransactionController::class,'selectCardtransaction']);
        Route::get('/notification',[AuthController::class,'getNotification']);
        Route::post('/contact',[AuthController::class,'contact']);
        Route::post('/user-delete',[AuthController::class,'userDelete']);
        });
    Route::group(['middleware'=>'jwt.auth'],function($router){
        Route::post('/requestwithdrawal',[WithdrawalController::class,'requestWithdrawal']);
        Route::get('/selectwithdrawal',[WithdrawalController::class,'selectWithdrawal']);

        });
    Route::group(['middleware'=>'jwt.auth'],function($router){
        Route::post('/usdttransaction',[UsdttransactionController::class,'addUsdttransaction']);
        Route::get('/selectusdttransaction',[UsdttransactionController::class,'selectUsdttransaction']);
        });
        Route::post('/password/{email}', [ForgotPasswordController::class,'forgot']);
        Route::post('/password/reset', [ForgotPasswordController::class,'reset']);
        Route::get('/cryptorates',[CryptoratesController::class,'cryptoRates']);
        Route::get('/usdtwallet',[CryptoratesController::class,'getUsdtWallet']);
        Route::get('/btcwallet',[CryptoratesController::class,'getBtcWallet']);
        Route::get('/cardrates',[CardRatesController::class,'cardRates']);
        Route::post('/notification',[AuthController::class,'newNotification']);
        Route::get('/sendmail',[AuthController::class,'sendmail']);
        Route::post('/push-token',[AuthController::class,'pushToken']);
        Route::post('/new-address',[CryptoWalletController::class,'cryptoAccount']);
        Route::get('/new-address',[CryptoWalletController::class,'getCryptoAccount']);
        Route::get('/supported-currencies', [CryptoWalletController::class, 'getSupportedCurrencies'])->name('supported-currencies');

        Route::group(['middleware' => 'jwt.auth'], function ($router) {
            Route::post('/sell', [CryptoTransactionController::class, 'sell']);

        });

        Route::post('resend-otp', [AuthController::class, 'resendOtp']);

        Route::post('/forgot-password', [ForgotPasswordController::class, 'forgot']);


       