<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Log In</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1" name="viewport" />
    <meta content="" name="description" />
    <meta content="" name="author" />

    <!-- BEGIN STYLES -->
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/admin/css/font-awesome.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/admin/css/simple-line-icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/admin/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/admin/css/uniform.default.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/admin/css/components-rounded.min.css')); ?>" rel="stylesheet" id="style_components" type="text/css" />
    <link href="<?php echo e(asset('assets/admin/css/plugins.min.css')); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('assets/admin/css/login.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- END STYLES -->

    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logo/favicon.png')); ?>" />

</head>

<body class=" login">
<div class="menu-toggler sidebar-toggler"></div>
<!-- BEGIN LOGO -->
<div class="logo">
    <a href="#"><img src="https://prestohq.io/wp-content/uploads/2022/01/presto-png1.png" alt="-" style="max-width: 150px"/> </a>
</div>
<!-- END LOGO -->


<div class="content">
    <h3 class="form-title font-green"></h3>

    <div class="alert alert-danger display-hide">
        <button class="close" data-close="alert"></button>
        <span> Enter User Name and password. </span>
    </div>

    <?php if(session()->has('message')): ?>
        <div class="alert alert-danger alert-dismissable">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <?php echo e(session()->get('message')); ?>

        </div>
    <?php endif; ?>
    <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <div class="alert alert-danger alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <?php echo $error; ?>

            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>


    <div class="form-group">
        <!--ie8, ie9 does not support html5 placeholder, so we just show field title for that-->
        <form method="POST" action="<?php echo e(route('login')); ?>">
        <?php echo csrf_field(); ?>
        <label class="control-label visible-ie8 visible-ie9">Email:</label>
        <input id="email" class="form-control form-control-solid placeholder-no-fix" type="email" autocomplete="off" placeholder="Email" name="email" required /> </div>
    <div class="form-group">
        <label class="control-label visible-ie8 visible-ie9">Password</label>
        <input id="password" class="form-control form-control-solid placeholder-no-fix" type="password" autocomplete="off" placeholder="Password" name="password" required /> </div>
    <div class="form-actions">
        <?php echo csrf_field(); ?>

        <button type="submit" class="btn green uppercase btn-block"><i class="fa fa-sign-in"></i>Verify</button>
    </div>
        </form>


<!-- END LOGIN FORM -->

</div>
<div class="copyright"><?php echo date("Y");?> &copy; .</div>

<!-- BEGIN SCRIPTS -->
<script src="<?php echo e(asset('assets/admin/js/jquery.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/admin/js/bootstrap.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/admin/js/js.cookie.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/admin/js/bootstrap-hover-dropdown.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/admin/js/jquery.slimscroll.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/admin/js/jquery.blockui.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/admin/js/jquery.validate.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/admin/js/additional-methods.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/admin/js/app.min.js')); ?>" type="text/javascript"></script>
<script src="<?php echo e(asset('assets/admin/js/login.min.js')); ?>" type="text/javascript"></script>
<!-- END SCRIPTS -->

</body>
</html>
<?php /**PATH /home/prestohq/api.prestohq.io/core/resources/views/auth/login.blade.php ENDPATH**/ ?>